/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.login;

import com.ibm.hwmca.fw.connmgr.ConnectionFactory;
import com.ibm.hwmca.fw.servlet.login.HmcPrincipal;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BobcatLogin
extends HttpServlet {
    private static final String TRACE_MASKF = "XLGNSRVF";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Trace.trace(TRACE_MASKF, "-> BobcatLogin.doGet");
        resp.setHeader("Cache-Control", "no-cache");
        ServletRuntime.initializeWebApplication(req, this.getServletContext());
        String username = req.getParameter("j_username");
        String password = req.getParameter("j_password");
        if (username == null) {
            throw new ServletException("No username specified");
        }
        if (password == null) {
            throw new ServletException("No password specified");
        }
        try {
            Trace.trace(TRACE_MASKF, "BobcatLogin: creating connection factory");
            ConnectionFactory connFactory = new ConnectionFactory(CommonSystem.getCommonSystem().getManagerHost(), 9940);
            connFactory.setUserAndPassword(username, CommonSystem.getCommonSystem().hashPassword(password.toUpperCase()));
            Trace.trace(TRACE_MASKF, "BobcatLogin: authenticated.. setting principal");
            HmcPrincipal principal = new HmcPrincipal(username, connFactory);
            req.getSession().setAttribute("PRINCIPAL", (Object)principal);
            resp.sendRedirect(resp.encodeRedirectURL("/hmc/connect"));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
            resp.sendRedirect(resp.encodeRedirectURL("/hmc/login.jsp?errorPage=1"));
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

